IF EXISTS (SELECT * FROM SYS.TRIGGERS WHERE NAME = 'TRG_RC_DEB_ENVIO_PENDENTE')
BEGIN
	DROP TRIGGER TRG_RC_DEB_ENVIO_PENDENTE
END

GO

CREATE TRIGGER TRG_RC_DEB_ENVIO_PENDENTE ON RC_DEB FOR INSERT
AS
BEGIN
    INSERT INTO 
      	RC_DEB_ENVIO_PENDENTE (CD_EMP, CD_FILIAL, CD_RC_DEB)
    SELECT 
     	I.CD_EMP,
     	I.CD_FILIAL,
    	     I.CD_RC_DEB
    FROM
    	   INSERTED I
		INNER JOIN PRC_FILIAL_CONFIG C ON
			I.CD_EMP = C.CD_EMP
			AND I.CD_FILIAL = C.CD_FILIAL
		INNER JOIN BC_CONTAS ON
			C.CD_EMP = BC_CONTAS.CD_EMP
			AND C.CD_FILIAL = BC_CONTAS.CD_FILIAL_CNT
			AND CASE WHEN ISNUMERIC(C.VALOR) = 1 THEN C.VALOR ELSE -1 END = BC_CONTAS.CD_CNT
	WHERE
		C.CD_CHAVE = 'CD_CONTA_PADRAO_REGISTRO_BOLETO_ON_LINE'
END
 


